
class Workflow:
    def __init__(
        self,
        name: str,
        llm_config,
        dataset: DatasetType,
    ) -> None:
        self.name = name
        self.dataset = dataset
        self.llm = create_llm_instance(llm_config)
        self.llm.cost_manager = CostManager()
        self.custom = operator.Custom(self.llm)
        self.sc_ensemble = operator.ScEnsemble(self.llm)

    async def __call__(self, problem: str):
        """
        Implementation of the workflow
        """
        ideas = []
        for _ in range(3):  # Generate 3 ideas
            idea = await self.custom(input=problem, instruction=prompt_custom.GENERATE_IDEA)
            ideas.append(idea['response'])
        
        best_idea = await self.sc_ensemble(solutions=ideas, problem=problem)
        
        prioritized_idea = await self.custom(input=f"Ideas: {ideas}\nBest idea: {best_idea['response']}", instruction=prompt_custom.PRIORITIZE_IDEA)
        
        elaborated_idea = await self.custom(input=problem + f"\nPrioritized idea: {prioritized_idea['response']}", instruction=prompt_custom.ELABORATE_IDEA)
        
        evaluation = await self.custom(input=elaborated_idea['response'], instruction=prompt_custom.EVALUATE_RESEARCH)
        
        refined_proposal = await self.custom(input=elaborated_idea['response'] + f"\nEvaluation: {evaluation['response']}", instruction=prompt_custom.REFINE_PROPOSAL)
        
        critical_analysis = await self.custom(input=refined_proposal['response'], instruction=prompt_custom.CRITICAL_ANALYSIS)
        
        final_solution = await self.custom(input=refined_proposal['response'] + f"\nCritical Analysis: {critical_analysis['response']}", instruction=prompt_custom.FINALIZE_PROPOSAL)
        
        return final_solution['response'], self.llm.cost_manager.total_cost
